LIBRARY IEEE; 
USE IEEE.std_logic_1164.ALL;
ENTITY dff IS
  GENERIC ( setup_time, hold_time : TIME );
  PORT( d, clk : IN std_logic;
        q : OUT std_logic);
BEGIN
  setup_check : PROCESS ( clk )
  BEGIN
    IF ( clk = '1' ) and ( clk'EVENT ) THEN
      ASSERT ( d'LAST_EVENT >= setup_time )
        REPORT "setup violation"
        SEVERITY ERROR;
    END IF;
  END PROCESS setup_check;

  hold_check : PROCESS (clk'DELAYED(hold_time))
  BEGIN
    IF ( clk'DELAYED(hold_time) = '1' ) and
              ( clk'DELAYED(hold_time)'EVENT ) THEN

      ASSERT ( d'LAST_EVENT = 0 ns ) OR ( d'LAST_EVENT > hold_time )
        REPORT "hold violation"
        SEVERITY ERROR;

    END IF;
  END PROCESS hold_check;
END dff;

ARCHITECTURE dff_behave OF dff IS
BEGIN
  dff_process : PROCESS ( clk )
  BEGIN
    IF ( clk = '1' ) AND ( clk'EVENT ) THEN
      q <= d;
    END IF;

  END PROCESS dff_process;
END dff_behave;


